/*____________________________________________________________________________
		Copyright (C) 2000 Network Associates, Inc.
        All rights reserved.

        $Id: CTimerImpDrv98.cpp,v 1.1 1999/09/12 04:33:31 nryan Exp $
____________________________________________________________________________*/

#include "pgpClassesConfig.h"
#include "CTimerImpDrv98.h"

_USING_PGP

// Class CTimerImpDrv98 member functions

CTimerImpDrv98::~CTimerImpDrv98()
{
	if (IsTimerRunning())
		StopTimer();
}

CComboError 
CTimerImpDrv98::StartTimer(
	CTimer::CallbackFunc	timerCallback, 
	void					*userData, 
	PGPUInt32				msInterval, 
	PGPBoolean				isPeriodic)
{
	pgpAssert(!IsTimerRunning());
	pgpAssertAddrValid(timerCallback, CTimer::CallbackFunc);

	CComboError	error;

	mTimerCallback	= timerCallback;
	mUserData		= userData;
	mMsInterval		= msInterval;
	mIsPeriodic		= isPeriodic;

	error = ScheduleTimeout();

	if (error.IsntError())
		mIsTimerRunning = TRUE;
		
	return error;
}

void 
CTimerImpDrv98::StopTimer()
{
	pgpAssert(IsTimerRunning());

	mStopTheTimer = TRUE;

	if (IsntNull(mTimerHandle))
	{
		Cancel_Time_Out(mTimerHandle);
		mTimerHandle = NULL;
	}

	mIsTimerRunning	= FALSE;
	mTimerCallback	= NULL;
	mUserData		= NULL;
}

void 
CTimerImpDrv98::TimerCallbackAux()
{
	mTimerHandle = NULL;
	mTimerCallback(mUserData);

	if (IsPeriodic() && !mStopTheTimer)
		ScheduleTimeout();
}

void 
_cdecl 
CTimerImpDrv98::TimerCallback(
	VMHANDLE			hVM, 
	Client_Reg_Struc	*pRegs, 
	PVOID				refData, 
	DWORD				tardiness)
{
	CTimerImpDrv98	*pImp	= static_cast<CTimerImpDrv98 *>(refData);
	pgpAssertAddrValid(pImp, CTimerImpDrv98);

	pImp->TimerCallbackAux();
}

CComboError 
CTimerImpDrv98::ScheduleTimeout()
{
	CComboError					error;
	static GlobalTimeoutThunk	thunk;

	mTimerHandle = PGPdisk_Set_Global_Timeout(mMsInterval, this, 
		TimerCallback, thunk);

	if (IsNull(mTimerHandle))
		error.pgpErr = kPGPError_SyncObjOpFailed;

	return error;
}
